﻿Public Class Form1
    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        ' >>>>> コンボボックス初期化 <<<<<
        With Combo_ModeSelect									'コンボボックス設定
            .Items.Clear()										'初期化
            .Items.Add("Cモード")								'項目登録
            .Items.Add("Eモード")
            .Items.Add("EAモード")
            .Items.Add("EDモード")
            .Items.Add("ESモード")
            .Text = Combo_ModeSelect.GetItemText(Combo_ModeSelect.Items(0))
        End With
		
		' >>>>> 通信回線初期化 <<<<<
        With SerialPort1										'シリアルポートの設定  
            .PortName = "COM3"                  				'ポート名  
            .BaudRate = 38400                   				'通信速度
			.Parity = IO.Ports.Parity.None      				'パリティ  
            .DataBits = 7                       				'ビット数
            .StopBits = IO.Ports.StopBits.Two   				'ストップビット
            .Handshake = IO.Ports.Handshake.RequestToSend		'ハンドシェイク方式の設定(RTS-CTS制御)
            .RtsEnable = True									'RTS信号＝High(受信可能)
            .ReadTimeout = 2000									'読取りタイムアウト時間。単位：msec
            .WriteTimeout = 2000								'書き込みタイムアウト時間。単位：msec
            Try
                .Open()                         				'シリアルポートのオープン  
            Catch Cable As Exception
				Call Err_disp(0, "")            				'接続エラー
                Application.Exit()
				Exit Sub
            End Try
        End With

        Output_Text.Text = "コンボボックスから転送モードを選択し、" & Chr(&HD) & "OMR読み取りをクリックして下さい。"

    End Sub

    Private Sub Button_Read_Click(sender As Object, e As EventArgs) Handles Button_Read.Click

        Dim Response As String = ""
        Dim TMCount As String = ""
        Dim ReciveCnt As String = ""
        Dim Mode As String = ""

		Button_Read.Enabled = False     						'処理中は読取ボタンを無効化する。

        ' >>>>> 本機の接続状態チェック <<<<<
        If SerialPort1.IsOpen = True Then
            If SerialPort1.DsrHolding = False Then              '接続チェック
                Call Err_disp(0, "")                            '接続エラー
                Exit Sub

            End If
            If SerialPort1.CtsHolding = False Then              '本機受信可能状態チェック
                Call Err_disp(0, "")                            '接続エラー
                Exit Sub
            End If
        Else
			Call Err_disp(0, "")                                '接続エラー
            Exit Sub
        End If

        ' >>>>> 初期化 <<<<<
        Try
            SerialPort1.Write(Chr(&H18) & Chr(&HD))				'初期化コマンド送信
            Response = Chr(SerialPort1.ReadByte)
        Catch CAN As TimeoutException
        	Call Err_disp(3, "")            					'タイムアウト
            Exit Sub
        End Try

        If Response <> Chr(&H6) Then
			Call Err_disp(1, "")            					'初期化エラー
            Exit Sub
        End If

		' >>>>> 読み取り設定 <<<<<
        Try
            SerialPort1.Write(Chr(&H13) & "12" & Chr(&HD))    	'読み取り行数指定コマンド(12行)

            SerialPort1.Write(Chr(&H10) & "T" & Chr(&HD))     	'タイミング形式指定コマンド送信(直下型)

            SerialPort1.Write(Chr(&H2) & "2" & Chr(&HD))

        Catch ReadSet As TimeoutException
        	Call Err_disp(3, "")                              	'タイムアウト
            Exit Sub
        End Try

        ' >>>>> カード読み取り <<<<<
        Try
            SerialPort1.Write("?" & Chr(&HD))					'カード読み取りコマンド送信
            ReciveCnt = 1                                   	'読み取りステータスの受信バイト数設定
            Response = Chr(SerialPort1.ReadByte)            	'読み取りステータス受信
            If Response <> "0" Then                         	'読み取りステータスチェック
				Call Err_disp(2, Response)						'読取エラー
                Exit Sub
            End If

            ' >>>>> タイミングマーク数の読み取り <<<<<
            SerialPort1.Write(Chr(&H5) & "T" & Chr(&HD))      	'タイミングマーク数読み取りコマンド送信
			ReciveCnt = 1										'タイミングマーク数の受信までウェイト.
            Do
                System.Windows.Forms.Application.DoEvents()
                TMCount = TMCount & Chr(SerialPort1.ReadByte.ToString) 'タイミングマーク数受信
            Loop Until TMCount.Length = 3                       'タイミングマーク数の受信までウェイト
            Output_Text.Text = "ﾀｲﾐﾝｸﾞﾏｰｸ数：" & TMCount & Chr(&HD) & Chr(&HA) 'タイミングマーク数表示
        Catch CardTM As TimeoutException
        	Call Err_disp(3, "")                            	'タイムアウト
            Exit Sub
        End Try

        ' >>>>> 転送モード分岐 <<<<<
        Mode = Combo_ModeSelect.SelectedIndex
        Select Case Mode
            Case 0
                Call C_Mode(TMCount)                            'Cモード転送
            Case 1, 2, 3, 4
                Call E_Series(TMCount, Mode)                    'E,EA,ED,ESモード転送
            Case Else
				Call Err_disp(99, "")                           '予期せぬエラー
                Exit Sub
        End Select

		Button_Read.Enabled = True                              '処理完了後、読取ボタンを有効にする。

    End Sub

    ' >>>>> Cモード読み取り(固定長データの読み取り) <<<<<
    Private Sub C_Mode(ByVal TMCount As String)
        Dim CMode As String = ""
        Try
            SerialPort1.Write(Chr(&H10) & "C001" & TMCount & Chr(&HD))          'Cモード読み取りコマンド送信
            Do
                System.Windows.Forms.Application.DoEvents()
                CMode = CMode & Chr(SerialPort1.ReadByte.ToString)              'Cモードデータ受信
            Loop Until CMode.Length = (3 * Val(TMCount))                      	'Cモードデータ受信までウェイト   
            '1欄分は3バイトなので3*タイミングマーク数
            '受信するまでループする                                   
            Output_Text.Text = Output_Text.Text & "Cモード：" & CMode & Chr(&HD) & Chr(&HA) 'Cモードデータを表示

        Catch CRead As TimeoutException
			Call Err_disp(3, "")        										'タイムアウト
            Exit Sub
        End Try
    End Sub

    ' >>>>> Eモード系読み取り <<<<<
    Private Sub E_Series(ByVal TMCount As String, ByVal Mode As String)
        Dim Response As String = ""
        Dim ReciveCnt As Integer = 0
        Try
            Select Case Val(Mode)                                               'コンボボックスで選択したモードに分岐
                Case 1
                    Output_Text.Text = Output_Text.Text & "Eモード：" & Chr(&HD) & Chr(&HA)
                    SerialPort1.Write(Chr(&H10) & "E001" & TMCount & Chr(&HD))
                                                                            	'Eモード読み取りコマンド送信
                Case 2
                    Output_Text.Text = Output_Text.Text & "EAモード：" & Chr(&HD) & Chr(&HA)
                    SerialPort1.Write(Chr(&H10) & "EA001" & TMCount & Chr(&HD))
                                                                            	'EAモード読み取りコマンド送信
                Case 3
                    Output_Text.Text = Output_Text.Text & "EDモード：" & Chr(&HD) & Chr(&HA)
                    SerialPort1.Write(Chr(&H10) & "ED001" & TMCount & Chr(&HD))
                                                                            	'EDモード読み取りコマンド送信
                Case 4
                    Output_Text.Text = Output_Text.Text & "ESモード：" & Chr(&HD) & Chr(&HA)
                    SerialPort1.Write(Chr(&H10) & "ES001" & TMCount & Chr(&HD))
                    															'ESモード読み取りコマンド送信
                Case Else
					Call Err_disp(99, "")           '予期せぬエラー
                    Exit Sub
            End Select

            Select Case Val(Mode)
' >>>>> E・EA・EDモード読み取り <<<<<
                Case 1, 2, 3
                    Dim EMode(Val(TMCount)) As String                           		'領域確保
                    Dim DataLength As Integer = 0
                    Do                                                          		'E,EA,EDモードデータ受信までウェイト
                        System.Windows.Forms.Application.DoEvents()
                        Response = Response & Chr(SerialPort1.ReadByte.ToString)        'E,EA,EDモードデータ受信
                        DataLength = InStr(Response, Chr(&HD))							'受信データを1欄毎に抽出
                        If DataLength <> 0 Then
                            EMode(ReciveCnt) = Strings.Left(Response, DataLength)
                            Output_Text.Text = Output_Text.Text & Format(ReciveCnt + 1, "000") &
                                "欄目：" & EMode(ReciveCnt) & Chr(&HA)
                            Response = Mid(Response, DataLength + 1)
                            ReciveCnt = ReciveCnt + 1
                        End If
                    Loop Until ReciveCnt = Val(TMCount)

' >>>>> ESモード読み取り <<<<<
                Case 4

                    Dim ESMode(1, Val(TMCount)) As String                       		'領域確保
                    Dim DataLength_MC As Integer = 0
                    Dim MCFlag As Integer                                       		'抽出対象選択フラグ

                    MCFlag = 0                                                 

                    Do                                                          		'ESモードデータ受信までウェイト
                        System.Windows.Forms.Application.DoEvents()
                        Response = Response & Chr(SerialPort1.ReadByte.ToString)        'ESモードデータ受信
                        If MCFlag = 0 Then
                            DataLength_MC = InStr(Response, Chr(&HD))					'マークデータを1欄毎に抽出
                            If DataLength_MC <> 0 Then
                                ESMode(MCFlag, ReciveCnt) = Strings.Left(Response, DataLength_MC)
                                Response = Mid(Response, DataLength_MC + 1)
                                MCFlag = 1                                      		'抽出データの切り替え
                            End If
                        ElseIf MCFlag = 1 Then
                            DataLength_MC = InStr(Response, Chr(&HD))					'濃度データを1欄毎に抽出
                            If DataLength_MC <> 0 Then
                                ESMode(MCFlag, ReciveCnt) = Strings.Left(Response, DataLength_MC)
                                Response = Mid(Response, DataLength_MC + 1)
                                Output_Text.Text = Output_Text.Text & Format(ReciveCnt + 1, "000") &
                                    "欄目：" & ESMode(0, ReciveCnt) & ESMode(1, ReciveCnt) & Chr(&HA)
                                MCFlag = 0                                      		'抽出データの切り替え
                                ReciveCnt = ReciveCnt + 1                       		'マーク・濃度を抽出したらループ回数インクリメント
                            End If
                        Else
                            Call Err_disp(99, "")   									'予期せぬエラー
                            Exit Sub
                        End If
                    Loop Until ReciveCnt = Val(TMCount)
                Case Else
					Call Err_disp(99, "")           									'予期せぬエラー
                    Exit Sub
            End Select
        Catch ESeriesRead As TimeoutException
			Call Err_disp(3, "")                    									'タイムアウト
            Exit Sub
        End Try
    End Sub

	' >>>>> エラー表示処理 <<<<<
    Private Sub Err_disp(ByVal errcode As Integer, ByVal Response As String)

        Select Case errcode
            Case 0      '接続エラー
                MessageBox.Show("本機の電源が投入されていないか," & Chr(&HD) &
                    "通信ケーブルが接続されていません!!",
                    "SR-450ｻﾝﾌﾟﾙﾌﾟﾛｸﾞﾗﾑ-1",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error)

            Case 1      '初期化エラー
                MessageBox.Show("初期化失敗!!",
                    "SR-450ｻﾝﾌﾟﾙﾌﾟﾛｸﾞﾗﾑ-1",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error)

            Case 2      '読取エラー
                MessageBox.Show("エラーが発生しました!!" & Chr(&HD) &
                    "読み取りステータス＝" & Response,
                    "SR-450ｻﾝﾌﾟﾙﾌﾟﾛｸﾞﾗﾑ-1",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error)

            Case 3      'タイムアウト
                Output_Text.Text = "タイムアウト"

            Case Else   '予期せぬエラー
                MessageBox.Show("予期せぬエラー",
                    "SR-450ｻﾝﾌﾟﾙﾌﾟﾛｸﾞﾗﾑ-1",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error)
        End Select

        Button_Read.Enabled = True          '読取ボタンの有効化

    End Sub

    Private Sub Form1_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        SerialPort1.Close()														'ポートクローズ
    End Sub																		'プログラム終了
End Class
